﻿var panelists = {
    pageTable: null,
    context: $("#main"),
    filter: "",
    viewPii: false,
    filterSearchStatus: "",
    customAttributes: ["Attribute0", "Attribute1", "Attribute2", "Attribute3", "Attribute4", "Attribute5", "Attribute6", "Attribute7", "Attribute8", "Attribute9"],
    refreshContent: function () {
        this.pageTable.a4datatable("refresh");
    },
    initialize: function () {
        $.when(a4.callServerMethod(a4.getAction("GetPanelistsPageConfiguration", "Panelists", "Panel"))).then(function (result) {
            var pathName = window.location.pathname;
            var page = pathName.substring(pathName.lastIndexOf('/') + 1);
            var attribute = panelists.customAttributes;
            panelists.viewPii = $("#CanReadPII").val() == "True";
            panelists.hasAttributes = (result == "NONE") ? false : true;
            panelists.selectedAttributes = (result == "NONE") ? "" : result;
            panelists.pageTable = $(".panelistsTable", panelists.context).a4datatable({
                height: "full",
                ajaxAction: a4.getAction("GetPanelists", "Panelists", "Panel"),
                ajaxParams: { "attributes": panelists.selectedAttributes },
                columns: [
                    { "Name": "Id", "Title": "ID", "Data": "Id", "Type": "numeric", "Width": "80px", "HideInSelector": true, "Visible": true },
                    { "Name": "Email", "Title": panelistsLocalizableTexts.Email, "Data": "Email", "HideInSelector": !panelists.viewPii, "Visible": panelists.viewPii },
                    { "Name": "Phone", "Title": panelistsLocalizableTexts.Phone, "Data": "Phone", "HideInSelector": !panelists.viewPii, "Visible": panelists.viewPii },
                    { "Name": "FirstName", "Title": panelistsLocalizableTexts.FirstName, "Data": "FirstName", "HideInSelector": !panelists.viewPii, "Visible": panelists.viewPii },
                    { "Name": "LastName", "Title": panelistsLocalizableTexts.LastName, "Data": "LastName", "HideInSelector": !panelists.viewPii, "Visible": panelists.viewPii },
                    { "Name": "UserName", "Title": panelistsLocalizableTexts.UserName, "Data": "UserName" },
                    { "Name": "Status", "Title": panelistsLocalizableTexts.Status, "Data": "Status" },
                    { "Name": "Groups", "Title": panelistsLocalizableTexts.Groups, "Data": "Groups", "Sortable": false },
                    { "Name": "Points", "Title": panelistsLocalizableTexts.Points, "Data": "Points", "Visible": false },
                    { "Name": "Gender", "Title": panelistsLocalizableTexts.Gender, "Data": "Gender", "Type": "enum", "EnumType": "Gender", "Visible": false },
                    { "Name": "DateOfBirth", "Title": panelistsLocalizableTexts.DateOfBirth, "Data": "DateOfBirth", "Type": "date", "HideInSelector": false, "Visible": false },
                    { "Name": "Language", "Title": panelistsLocalizableTexts.Language, "Data": "Language", "Visible": false },
                    { "Name": "TimeZone", "Title": panelistsLocalizableTexts.TimeZone, "Data": "TimeZone", "Visible": false },
                    { "Name": "IsAnonymized", "Title": panelistsLocalizableTexts.Anonymized, "Data": "IsAnonymized", "Type": "boolean", "ShowIcon": true, "Visible": false },
                    { "Name": "CreatedOn", "Title": panelistsLocalizableTexts.CreatedOn, "Data": "CreatedOn", "Type": "date", "HideInSelector": !enablePanelistTraceability, "Visible": enablePanelistTraceability },
                    { "Name": "ConfirmedOn", "Title": panelistsLocalizableTexts.ConfirmedOn, "Data": "ConfirmedOn", "Type": "date", "HideInSelector": !enablePanelistTraceability, "Visible": enablePanelistTraceability },
                    { "Name": attribute[0], "Title": attribute[0], "Data": attribute[0], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[1], "Title": attribute[1], "Data": attribute[1], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[2], "Title": attribute[2], "Data": attribute[2], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[3], "Title": attribute[3], "Data": attribute[3], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[4], "Title": attribute[4], "Data": attribute[4], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[5], "Title": attribute[5], "Data": attribute[5], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[6], "Title": attribute[6], "Data": attribute[6], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[7], "Title": attribute[7], "Data": attribute[7], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[8], "Title": attribute[8], "Data": attribute[8], "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": attribute[9], "Title": attribute[9], "Data": attribute[9], "Visible": false, "HideInSelector": true, "EncodeHtml": true }
                ],
                stateKey: "Panelists",
                defaultSorting: "Id",
                lengthMenu: [
                    [10, 20, 50, 100, 500, 1000],
                    ['10', '20', '50', '100', '500', '1000']
                ],
                toolBarItems: [
                    {} // if no toolbar object, the "select" action on the a4.datatable is diabled
                ],
                contextMenuItems: [
                    { "Action": "edit", "Label": panelistsLocalizableTexts.Edit, "Visible": canModify },
                    { "Action": "surveys", "Label": panelistsLocalizableTexts.Surveys },
                    { "Action": "history", "Label": panelistsLocalizableTexts.History },
                    { "Action": "pointtransactions", "Label": panelistsLocalizableTexts.PointTransactions }
                ],
                contextMenuClick: function (event, data) {
                    var action = data.action;
                    var row = data.row;

                    switch (action) {
                        case "edit":
                            modalDialog.showWindow(a4.getAction("EditPanelist", "Panelists", "Panel", { PanelistId: row.Id }), 550, 550, {
                                afterClose: function () {
                                    $(".panelistsTable", panelists.context).a4datatable("refresh", true);
                                }
                            });
                            break;
                        case "surveys":
                            modalDialog.showWindow(a4.getAction("PanelistSurveys", "Panelists", "Panel", { PanelistId: row.Id }), 700, 950);
                            break;
                        case "history":
                            modalDialog.showWindow(a4.getAction("PanelistHistory", "Panelists", "Panel", { PanelistId: row.Id }), 700, 880);
                            break;
                        case "pointtransactions":
                            modalDialog.showWindow(a4.getAction("PanelistPoints", "Panelists", "Panel", { PanelistId: row.Id }), 750, 880);
                            break;
                    }
                },
                localizableTexts: { "Search": panelistsLocalizableTexts.SearchPanelists },
                draw: function (event, data) {
                    $(".panelistFilter").trigger("filterApplied");
                    $("#main-header .panel-size > span").html(data.totalRecords);
                },
                error: function (event, data) {
                    $(".panelistFilter").trigger("filterApplied");
                    a4.showErrorMessage(panelistsLocalizableTexts.ApplyFilterError);
                },
                ready: function () {
                    panelists.rearrangeColumnSelector();
                    panelists.toggleAllPanelistsActionsDropdown();
                },
                customCallback: function (requestData, resultData, textStatus, jqXHR) {
                    panelists.filterSearchStatus = jqXHR.getResponseHeader("PanelistFilterSearchStatus");
                    panelists.togglePanelistFilter();
                    panelists.showSelectedActionsOnSelectAll();
                    panelists.showSelectedActionsOnSelectRow();
                    panelists.hideSelectedActionsOnItemCountChange();
                    panelists.hideSelectedActionsOnOrderBy();
                    panelists.hideSelectedActionsOnPaginate();
                    panelists.displayAttributeSelector();
                    panelists.toggleAttributeColumns(); //To get latest names of header after every refresh too not only on table load.
                    panelists.updateFilteredRecordCount(requestData, resultData);
                    panelists.toggleAllPanelistsActionsDropdown();

                },
                customColumns: { "Label": panelistsLocalizableTexts.AddAttributes, "Visible": panelists.hasAttributes }
            });
        });
    },
    bindEvents: function () {
        $(".h-addPanelist", panelists.context).on("click", function () {
            modalDialog.showWindow(a4.getAction("AddPanelist", "Panelists", "Panel"), 550, 550, {
                afterClose: function () {
                    panelists.toggleAllPanelistsActionsDropdown();
                    $(".panelistsTable", panelists.context).a4datatable("refresh", true);
                }
            });
        });

        $(".h-importPanelists", panelists.context).on("click", function () {
            a4.parent().location.assign(a4.getAction("Index", "Import", "Panel"))
        });

        $(".h-exportPanelist", panelists.context).on("click", function () {
            a4.parent().ExportPanelists(a4.parent().panelistFilter.getFilter(), 0);
        });
                
        $(".h-viewPanelPoints", panelists.context).on("click", function () {
            //Single panel update
            a4.showBusyBox();
            modalDialog.showHTML(a4.getAction("PanelPoints", "Panelists", "Panel", { filter: JSON.stringify({ Content: panelists.filter, PanelId: $("#survey-block").attr("data-panelid") }) }), 700, 950);
            a4.hideBusyBox();
        });

        $(".panelistFilter").on("filterChanged", function (e, filterDefinition) {
            panelists.filter = JSON.stringify(filterDefinition);
            $(".panelistsTable", panelists.context).a4datatable("option", "ajaxParams", { "customParams": { "filter": panelists.filter } });
            $(".panelistsTable", panelists.context).a4datatable("refresh", true);
            e.stopPropagation();
        });

        $(".panelistFilter").on("applyExpandedFilter", function (e, filterDefinition) {
            a4.callServerMethod(a4.getAction("PanelistFilterExpandedConfiguration", "Panelists", "Panel"), { filterDefinition: JSON.stringify(filterDefinition), applyToSubFilter: true },
                function (result) {
                    a4.hideBusyBox();
                    modalDialog.close();
                    top.panelistFilter.context.html(result);
                    top.panelistFilter.initializeAutoCompletes();
                    $(".filtersAutoComplete", top.panelistFilter.context).a4autocomplete("clearCache");
                },
                function (error) {
                    a4.hideBusyBox();
                    a4.onAjaxPageMethodError(error);
                },
                { contentType: "application/json", dataType: "html" });
            
            e.stopPropagation();
        });

        $(".toggleFilter", panelists.context).on("click", function () {
            $(".panelistFilter", panelists.context).toggle();
            $("span", $(this)).toggle();
        });

        panelists.context.on("click", ".section-header, .v-createFilterMessage", function () {
            var sectionBox = $(this).closest(".section-box");
            panelists.toggleRespondentFilter(sectionBox);
        });

        $(".v-toolBarButtonForApplyOnAllRecords", panelists.context).on("click", function () {
            var action = $(this).attr("data-action")
            var totalRecords = panelists.pageTable.a4datatable("getTotalRecords");
            var panelId = $("#survey-block").attr("data-panelid");
            var self = $(".panelistsTable", panelists.context);
            if (action == "delete") {
                modalDialog.showConfirmDialog(confirmDeletePanelistsResources, function () {
                    a4.showBusyBox();
                    a4.callServerMethod(a4.getAction("DeleteAll", "Panelists", "Panel"), { panelId: panelId},
                        function (result) {
                            panelists.toggleAllPanelistsActionsDropdown();
                            self.a4datatable("refresh", true);
                            a4.hideBusyBox();
                        });
                }, 250, 500, true, { "count": totalRecords, "confirmButtonType": "important" });
            }
            else if (action == "activate") {
                modalDialog.showConfirmDialog(confirmActivatePanelistsResources, function () {
                    a4.showBusyBox();
                    a4.callServerMethod(a4.getAction("ActivateAll", "Panelists", "Panel"), { panelId: panelId },
                        function (result) {
                            self.a4datatable("refresh", true);
                            a4.hideBusyBox();
                        });
                }, 250, 500, true, { "count": totalRecords, "confirmButtonType": "important" });
            }
            else if (action == "deactivate") {
                modalDialog.showConfirmDialog(confirmDeactivatePanelistsResources, function () {
                    a4.showBusyBox();
                    a4.callServerMethod(a4.getAction("DeactivateAll", "Panelists", "Panel"), { panelId: panelId },
                        function (result) {
                            self.a4datatable("refresh", true);
                            a4.hideBusyBox();
                        });
                }, 250, 500, true, { "count": totalRecords, "confirmButtonType": "important" });
            }
            else if (action == "anonymize") {
                modalDialog.showConfirmDialog(panelistsLocalizableTexts, function () {
                    a4.showBusyBox();
                    a4.callServerMethod(a4.getAction("AnonymizeAll", "Panelists", "Panel"), { panelId: panelId },
                        function (result) {
                            self.a4datatable("refresh", true);
                            a4.hideBusyBox();
                        });
                }, 300, 500, true, { "count": totalRecords, "confirmButtonType": "important" });
            }
        });
    },
    toggleRespondentFilter: function (sectionBox) {
        sectionBox.find(".section-header .fa").toggleClass("fa-caret-right fa-caret-down");
        $(".section-content", sectionBox).toggle();

        if ($(".section-content", sectionBox).is(":visible") || panelistFilter.filterLoaded) {
            $(".v-createFilterMessage", sectionBox).hide();
            $(".buttons", sectionBox).show();
        }
        else {
            $(".v-createFilterMessage", sectionBox).show();
            $(".buttons", sectionBox).hide();
        }
    },
    togglePanelistFilter: function () {
        $('.toggle-respondent-filter-show').remove();

        $("div.toolBar").parent().prepend(
            `<button class="hideItem toggle-respondent-filter-show">
                         <span class= "fa fa-filter"></span >
             </button >`
        );

        if ($('.panelistfilter-left-section').hasClass('hideItem')) {
            $('.toggle-respondent-filter-show').removeClass('hideItem');
        }
    },
    toggleFilteredAction: function () {
        $(".v-toolBarButtonForFilteredRecords", panelists.context).on("click", function () {
            var action = $(this).attr("data-action")
            var totalFilteredRecords = panelists.pageTable.a4datatable("getDisplayedRecords");
            var tableParams = panelists.pageTable.a4datatable("getTableParams");
            var search = tableParams.IsSearch ? tableParams.Search : "";
            var panelId = $("#survey-block").attr("data-panelid");
            var self = $(".panelistsTable", panelists.context);
            var appliedFilter = { "filter": JSON.stringify(panelistFilter.getFilter()) };

            switch (action) {
                case "delete":
                    modalDialog.showConfirmDialog(confirmDeleteFilteredPanelistsResources, function () {
                        a4.showBusyBox();
                        a4.callServerMethod(a4.getAction("DeleteFilteredPanelist", "Panelists", "Panel"), { panelId: panelId, customParams: appliedFilter, search: search, attributes: panelists.selectedAttributes },
                            function (result) {
                                panelists.toggleAllPanelistsActionsDropdown();
                                a4.hideBusyBox();
                                self.a4datatable("refresh", true);
                            });
                    }, 250, 500, true, { "count": totalFilteredRecords, "confirmButtonType": "important" });
                    a4.parent().panelistFilter.toggleFilteredActionDropdown(true);
                    break;
                case "activate":
                    modalDialog.showConfirmDialog(confirmActivateFilteredPanelistsResources, function () {
                        a4.showBusyBox();
                        a4.callServerMethod(a4.getAction("ActivateFilteredPanelist", "Panelists", "Panel"), { panelId: panelId, customParams: appliedFilter, search: search, attributes: panelists.selectedAttributes },
                            function (result) {
                                a4.hideBusyBox();
                                self.a4datatable("refresh", true);
                            });
                    }, 250, 500, true, { "count": totalFilteredRecords, "confirmButtonType": "important" });
                    a4.parent().panelistFilter.toggleFilteredActionDropdown(true);
                    break;
                case "deactivate":
                    modalDialog.showConfirmDialog(confirmDeactivateFilteredPanelistsResources, function () {
                        a4.showBusyBox();
                        a4.callServerMethod(a4.getAction("DeactivateFilteredPanelist", "Panelists", "Panel"), { panelId: panelId, customParams: appliedFilter, search: search, attributes: panelists.selectedAttributes },
                            function (result) {
                                a4.hideBusyBox();
                                self.a4datatable("refresh", true);
                            });
                    }, 250, 500, true, { "count": totalFilteredRecords, "confirmButtonType": "important" });
                    a4.parent().panelistFilter.toggleFilteredActionDropdown(true);
                    break;
                case "anonymize":
                    modalDialog.showConfirmDialog(confirmAnonymizeFilteredPanelistsResources, function () {
                        a4.showBusyBox();
                        a4.callServerMethod(a4.getAction("AnonymizeFilteredPanelist", "Panelists", "Panel"), { panelId: panelId, customParams: appliedFilter, search: search, attributes: panelists.selectedAttributes },
                            function (result) {
                                a4.hideBusyBox();
                                self.a4datatable("refresh", true);
                            });
                    }, 300, 500, true, { "count": totalFilteredRecords, "confirmButtonType": "important" });
                    a4.parent().panelistFilter.toggleFilteredActionDropdown(true);
                    break;
                case "export":
                    a4.parent().ExportPanelists(a4.parent().panelistFilter.getFilter(), 0);
                    break;
                case "pointtransactions":
                    //Filter Panel Point Update
                    a4.showBusyBox();
                    modalDialog.showHTML(a4.getAction("PanelPoints", "Panelists", "Panel", { filter: JSON.stringify({ ActionType: "Filtered", Content: panelists.filter, PanelId: panelId }) }), 700, 950);
                    a4.hideBusyBox();
                    break;
                case "sendConfirmationLink":
                    a4.showBusyBox();
                    a4.callServerMethod(a4.getAction("SendConfirmationLinkForFilteredPanelist", "Panelists", "Panel"), { panelId: panelId, customParams: appliedFilter, search: search, attributes: panelists.selectedAttributes },
                        function (result) {
                            self.a4datatable("refresh", true);
                            a4.hideBusyBox();
                            var responseData = JSON.parse(result.StatusDescription);
                            a4.showSuccessMessage(responseData.Message);
                        });
                    break;
            }
        });
    },
    initializeSelectedActionDropdown: function (totalselectedRecords) {
        if (!$("#selectedActionDropdown").length) {
            if ($("#filteredActionDropdown").length)
                $("#filteredActionDropdown").replaceWith(selectedActionDropdown);
            else
                $("div.toolBar").parent().prepend(selectedActionDropdown);
            panelists.toggleSelectedAction();
            panelists.toggleSendConfirmationLink();
        }
        if (totalselectedRecords > 0) {
            $("#selectedActionDropdown").show();
        }
        else {
            $("#selectedActionDropdown").hide();
            if (panelists.filterSearchStatus === 'SEARCHISAPPLIED') {
                panelistFilter.toggleFilteredActionDropdown(true);
            }
            else {
                panelistFilter.toggleFilteredActionDropdown(false);
            }
        }        
        $('#selectedActionDropdown > div > div').html(function () {
            return $(this).html().replace($(this).text(), panelistsLocalizableTexts.SelectedActionText + " (" + totalselectedRecords + ")");
        });
    },
    toggleSelectedAction: function () {
        $(".v-toolBarButtonForSelectedRecords", panelists.context).on("click", function () {
            var action = $(this).attr("data-action")
            var rows = panelists.pageTable.a4datatable("getSelectedItems");
            var totalSelectedRecords = rows.length;
            var self = $(".panelistsTable", panelists.context);
            var panelId = $("#survey-block").attr("data-panelid");

            switch (action) {
                case "delete":
                    modalDialog.showConfirmDialog(confirmDeleteSelectedPanelistsResources, function () {
                        a4.showBusyBox();
                        a4.callServerMethod(a4.getAction("DeleteSelected", "Panelists", "Panel"), { ids: _.pluck(rows, "Id") },
                            function (result) {
                                self.a4datatable("refresh", true);
                                a4.hideBusyBox();
                                panelists.initializeSelectedActionDropdown(0);
                                panelists.toggleAllPanelistsActionsDropdown();
                            });
                    }, 250, 500, true, { "count": rows.length, "confirmButtonType": "important" });
                    break;
                case "activate":
                    modalDialog.showConfirmDialog(confirmActivateSelectedPanelistsResources, function () {
                        a4.showBusyBox();
                        a4.callServerMethod(a4.getAction("ActivateSelected", "Panelists", "Panel"), { ids: _.pluck(rows, "Id") },
                            function (result) {
                                self.a4datatable("refresh", true);
                                a4.hideBusyBox();
                                panelists.initializeSelectedActionDropdown(0);
                            });
                    }, 250, 500, true, { "count": rows.length, "confirmButtonType": "important" });
                    break;
                case "deactivate":
                    modalDialog.showConfirmDialog(confirmDeactivateSelectedPanelistsResources, function () {
                        a4.showBusyBox();
                        a4.callServerMethod(a4.getAction("DeactivateSelected", "Panelists", "Panel"), { ids: _.pluck(rows, "Id") },
                            function (result) {
                                self.a4datatable("refresh", true);
                                a4.hideBusyBox();
                                panelists.initializeSelectedActionDropdown(0);
                            });
                    }, 250, 500, true, { "count": rows.length, "confirmButtonType": "important" });
                    break;
                case "anonymize":
                    modalDialog.showConfirmDialog(confirmAnonymizeSelectedPanelistsResources, function () {
                        a4.showBusyBox();
                        a4.callServerMethod(a4.getAction("AnonymizeSelected", "Panelists", "Panel"), { ids: _.pluck(rows, "Id") },
                            function (result) {
                                self.a4datatable("refresh", true);
                                a4.hideBusyBox();
                                panelists.initializeSelectedActionDropdown(0);
                            });
                    }, 300, 500, true, { "count": rows.length, "confirmButtonType": "important" });
                    break;
                case "export":
                    a4.parent().SyncExportPanelists(a4.parent().panelistFilter.getFilter(), 0, _.pluck(rows, "Id"));
                    break;
                case "pointtransactions":
                    //Selected Panel point update
                    a4.showBusyBox();
                    modalDialog.showHTML(a4.getAction("PanelPoints", "Panelists", "Panel", { filter: JSON.stringify({ ActionType: "Selected", Content: panelists.filter, PanelId: panelId, SelectedPanelists: _.pluck(rows, "Id") }) }), 700, 950);
                    a4.hideBusyBox();
                    break;
                case "sendConfirmationLink":
                    a4.showBusyBox();
                    a4.callServerMethod(a4.getAction("SendConfirmationLinkForSelectedPanelist", "Panelists", "Panel"),
                        { ids: rows.filter(v => v.ConfirmedOn == null || v.ConfirmedOn == "").map(obj => obj.Id) },
                        function (result) {
                            self.a4datatable("refresh", true);
                            a4.hideBusyBox();
                            var responseData = JSON.parse(result.StatusDescription);
                            a4.showSuccessMessage(responseData.Message);
                        });
                    break;
            }
        });
    },
    removeSelectedActionsDropdown: function () {
        if ($("#selectedActionDropdown").length) {
            if ($("#filteredActionDropdown").length) {
                $("#selectedActionDropdown").replaceWith(filteredActionDropdown);
            }
            else {
                $("#selectedActionDropdown").replaceWith('');
            }
        }
    },
    showSelectedActionsOnSelectAll: function () {
        $(".h-selectAll", panelists.pageTable.context).on("click", function () {
            var selectedRecords = $("tr.selected").length;
            if (selectedRecords == $(".selectRow").length)
                selectedRecords = 0;
            else
                selectedRecords = $(".selectRow").length;
            panelists.initializeSelectedActionDropdown(selectedRecords);
        });
    },
    showSelectedActionsOnSelectRow: function () {
        $(".selectRow", panelists.pageTable.context).on("click", function () {
            var totalselectedRecords = $("tr.selected").length;

            if ($(this).closest("tr").hasClass("selected"))
                totalselectedRecords--;
            else
                totalselectedRecords++;

            panelists.initializeSelectedActionDropdown(totalselectedRecords);
        });
    },
    hideSelectedActionsOnItemCountChange: function () {
        panelists.removeSelectedActionsDropdown();
    },
    hideSelectedActionsOnOrderBy: function () {
        panelists.removeSelectedActionsDropdown();
    },
    hideSelectedActionsOnPaginate: function () {
        panelists.removeSelectedActionsDropdown();
    },
    toggleSendConfirmationLink: function () {
        $("#selectedActionDropdown", panelists.context).on("click", function () {
            var selectedRows = panelists.pageTable.a4datatable("getSelectedItems");
            if (selectedRows.filter(v => v.ConfirmedOn == null || v.ConfirmedOn == "").length > 0)
                $('li.v-toolBarButtonForSelectedRecords[data-action="sendConfirmationLink"]').removeClass("hideItem");

            else
                $('li.v-toolBarButtonForSelectedRecords[data-action="sendConfirmationLink"]').addClass("hideItem");
        });
    },
    hasAttributes: false,
    selectedAttributes: null,
    displayAttributeSelector: function () {
        $(".btn-add-custom-column", panelists.context).on("click", function () {
            modalDialog.showWindow(a4.getAction("AddAttributes", "Panelists", "Panel", { attributes: panelists.selectedAttributes || "" }), 600, 800, {
                beforeClose: function () {
                    var attributeSelector = $('.fancybox-iframe').contents();
                    var confirmed = attributeSelector.find(".v-confirmed").val();
                    if (confirmed) {
                        var value = attributeSelector.find('.v-selectedAttributes').val();
                        panelists.selectAttributes(value);
                    }
                }
            });
        });
    },
    selectAttributes: function (attributes) {
        panelists.selectedAttributes = attributes;

        panelists.pageTable.a4datatable("option", "ajaxParams", { "attributes": attributes });
        var panelId = $("#survey-block").attr("data-panelid");
        a4.callServerMethod(a4.getAction("UpdatePanelistsPageConfiguration", "Panelists", "Panel"), { panelId: panelId, config: attributes },
            function (result) {
                panelists.toggleAttributeColumns();
                panelists.pageTable.a4datatable("refresh", true);
            }
        );
    },
    toggleAttributeColumns: function () {
        a4.callServerMethod(a4.getAction("GetPanelistsPageConfigurationNamesById", "Panelists", "Panel"), { config: panelists.selectedAttributes }).then(function (result) {
            var responseArray = [];

            if (result && result.configResultBasedOnPageSetting) {
                responseArray = JSON.parse(result.configResultBasedOnPageSetting);
            }

            //For hiding setting menu all custom attributes
            panelists.customAttributes.forEach((atrributeUIName) => {
                panelists.pageTable.a4datatable("toggleSettingMenuOption", atrributeUIName, 'a', false, atrributeUIName);
                panelists.pageTable.a4datatable("toggleColumn", atrributeUIName, false);
            })

            //For selected attribute 
            responseArray.forEach((attribute, index) => {
                //Showing column in table if visible is set true in page setting
                panelists.pageTable.a4datatable("toggleColumn", attribute["UIFieldName"], attribute["Visible"]);
                panelists.pageTable.a4datatable("changeColumnTitle", attribute["UIFieldName"], attribute["Name"]);

                //Showing settings options for selected attributes
                panelists.pageTable.a4datatable("toggleSettingMenuOption", attribute["UIFieldName"], 'a', true, attribute["Name"]);
            })
        });     
    },
    replaceTextValueInSettingMenu: function (currentSettingElement, replaceWithText, visible) {
        if (currentSettingElement.length > 0) {
            currentSettingElement.contents()
                .filter(function () {
                    // Filter out empty or whitespace-only text nodes
                    if (replaceWithText && visible && this.nodeType === 3 && this.nodeValue.trim() !== '') {
                        this.nodeValue = replaceWithText;
                        $(this).closest('li').show();
                    }
                    else {
                        $(this).closest('li').hide();
                    }
                });
        }
    },
    rearrangeColumnSelector: function () {
        var columnSelectorDiv = $("div.settings-menu");
        var columnSelectorUl = columnSelectorDiv.find("ul.dropdown-menu");
        var columnSelectorLi = columnSelectorUl.find("li:nth-child(-n+10)");
        var btnAddAtribute = columnSelectorUl.find("li[data-column-name='CustomColumnSelector']");
        var height = 0;

        columnSelectorUl.css("overflow-y", "auto")
        columnSelectorUl.find("li").css("height", "30px")
        columnSelectorLi.each(function () {
            height += $(this).height();
        });

        if (btnAddAtribute.length) {
            btnAddAtribute.css({
                position: "fixed",
                paddingBottom: "5px",
                backgroundColor: "#ffffff",
                top: (height + columnSelectorDiv[0].getBoundingClientRect().top + columnSelectorDiv.outerHeight() + 4) + "px"
            });
            btnAddAtribute.addClass("divider");
            height += columnSelectorLi.height();
            columnSelectorUl[0].style.paddingBottom = btnAddAtribute.outerHeight() + "px";
        }
        columnSelectorUl[0].style.maxHeight = (height + 15) + "px";
    },
    updateFilteredRecordCount: function (requestData, resultData) {
        var filteredRecords = panelists.pageTable.a4datatable("getDisplayedRecords");
        var totalRecords = panelists.pageTable.a4datatable("getTotalRecords");
        var searchFilterValue = $(".dataTables_filter input", panelists.context).val();

        if (panelistFilter.filterLoaded || panelists.filterSearchStatus === 'SEARCHISAPPLIED') {
            panelistFilter.toggleFilteredActionDropdown(true);
        }
        else{
            panelistFilter.toggleFilteredActionDropdown(false);
        }

        $('#filteredActionDropdown > div > div').html(function () {
            return $(this).html().replace($(this).text(), panelistsLocalizableTexts.FilteredActionText + " (" + filteredRecords + ")");
        });
    },
    toggleAllPanelistsActionsDropdown: function () {
        var totalPanelistsRecords = panelists.pageTable.a4datatable("getTotalRecords");
        (totalPanelistsRecords > 0)? $(".toolbar > .button-group-actions").show() : $(".toolbar > .button-group-actions").hide();
    }
};

$(document).ready(function () {
    panelists.initialize();
    panelists.bindEvents();
});